from django.urls import path
from . import views

app_name = "website"

urlpatterns = [
    path("support/panel/preview/", views.support_panel_preview, name="support_panel_preview"),

    path('support/', views.support_ticket_create, name='support_ticket_create'),
    path('support/thanks/<str:public_id>/<str:secret>/', views.support_ticket_thanks, name='support_ticket_thanks'),
    path('support/t/<str:public_id>/<str:secret>/', views.support_ticket_view, name='support_ticket_view'),
    path('staff/support/', views.staff_support_dashboard, name='staff_support_dashboard'),
    path('staff/support-analytics/', views.staff_support_analytics, name='staff_support_analytics'),
    path('staff/notifications/poll/', views.staff_notifications_poll, name='staff_notifications_poll'),
    path('staff/notifications/mark-read/', views.staff_notifications_mark_read, name='staff_notifications_mark_read'),
    path('staff/support/<str:public_id>/', views.staff_support_ticket, name='staff_support_ticket'),
    path('offline/', views.offline, name='offline'),
    path('request-care/', views.care_request_step1, name='care_request_step1'),
    path('request-care/step-2/', views.care_request_step2, name='care_request_step2'),
    path('request-care/step-3/', views.care_request_step3, name='care_request_step3'),
    path('request-care/review/', views.care_request_review, name='care_request_review'),
    path('request-care/success/', views.care_request_success, name='care_request_success'),
    path('staff/care/', views.staff_care_dashboard, name='staff_care_dashboard'),
    path('staff/care/assign/', views.staff_assignment_create, name='staff_assignment_create'),
    path('caregiver/portal/', views.caregiver_portal, name='caregiver_portal'),
    path('whatsapp/webhook/', views.whatsapp_webhook, name='whatsapp_webhook'),

    path("", views.home, name="home"),
    path("about/", views.about, name="about"),
    path("services/", views.services, name="services"),
    path("care-process/", views.care_process, name="care_process"),
    path("why-choose-us/", views.why_choose_us, name="why_choose_us"),
    path("testimonials/", views.testimonials, name="testimonials"),

    path("careers/", views.careers, name="careers"),
    path("careers/success/", views.careers_success, name="careers_success"),

    path("contact/", views.contact, name="contact"),
    path("contact/success/", views.contact_success, name="contact_success"),

    path("blog/", views.BlogListView.as_view(), name="blog_list"),
    path("blog/<slug:slug>/", views.BlogDetailView.as_view(), name="blog_detail"),

    path("privacy/", views.legal_privacy, name="legal_privacy"),
    path("terms/", views.legal_terms, name="legal_terms"),
    path("disclaimer/", views.legal_disclaimer, name="legal_disclaimer"),
]
