from django.contrib import admin
from .models import Service, Testimonial, BlogPost, CareerPosition, Enquiry, CareerApplication, CareRequest, CaregiverProfile, CareAssignment

@admin.register(Service)
class ServiceAdmin(admin.ModelAdmin):
    list_display = ("title", "is_featured", "sort_order")
    list_editable = ("is_featured", "sort_order")
    prepopulated_fields = {"slug": ("title",)}

@admin.register(Testimonial)
class TestimonialAdmin(admin.ModelAdmin):
    list_display = ("name", "is_published", "created_at")
    list_filter = ("is_published",)

@admin.register(BlogPost)
class BlogPostAdmin(admin.ModelAdmin):
    list_display = ("title", "is_published", "published_at")
    list_filter = ("is_published",)
    prepopulated_fields = {"slug": ("title",)}

@admin.register(CareerPosition)
class CareerPositionAdmin(admin.ModelAdmin):
    list_display = ("title", "role_type", "is_open")
    list_filter = ("role_type", "is_open")

@admin.register(Enquiry)
class EnquiryAdmin(admin.ModelAdmin):
    list_display = ("full_name", "enquiry_type", "phone", "is_resolved", "created_at")
    list_filter = ("enquiry_type", "is_resolved")
    search_fields = ("full_name", "phone", "email")

@admin.register(CareerApplication)
class CareerApplicationAdmin(admin.ModelAdmin):
    list_display = ("full_name", "email", "phone", "position", "created_at")


@admin.register(CareRequest)
class CareRequestAdmin(admin.ModelAdmin):
    list_display = ("created_at", "full_name", "request_type", "status", "phone", "location")
    list_filter = ("request_type", "status")
    search_fields = ("full_name", "phone", "email", "location", "care_needs")

@admin.register(CaregiverProfile)
class CaregiverProfileAdmin(admin.ModelAdmin):
    list_display = ("user", "phone", "location", "is_active")
    list_filter = ("is_active",)
    search_fields = ("user__username", "user__first_name", "user__last_name", "phone", "location", "skills")

@admin.register(CareAssignment)
class CareAssignmentAdmin(admin.ModelAdmin):
    list_display = ("created_at", "care_request", "caregiver", "status", "start_date", "end_date")
    list_filter = ("status",)
    search_fields = ("care_request__full_name", "caregiver__user__username")


from .models import SupportTicket, SupportMessage, StaffNotification

@admin.register(SupportTicket)
class SupportTicketAdmin(admin.ModelAdmin):
    list_display = ("public_id","full_name","subject","status","created_at")
    list_filter = ("status",)
    search_fields = ("public_id","full_name","phone","email","subject")

@admin.register(SupportMessage)
class SupportMessageAdmin(admin.ModelAdmin):
    list_display = ("ticket","sender","created_at")
    search_fields = ("ticket__public_id","message")


@admin.register(StaffNotification)
class StaffNotificationAdmin(admin.ModelAdmin):
    list_display = ("user","title","is_read","created_at")
    list_filter = ("is_read","kind")
    search_fields = ("title","body","user__username","user__email")
