# Deployment Guide (cPanel / VPS / DigitalOcean)

This project is a Django app with SQLite by default. For production, use MySQL/PostgreSQL, turn off DEBUG, and serve via Gunicorn + Nginx (VPS/DO) or cPanel Python App.

## 1) Environment variables (.env)
Create a `.env` in the project root:

```
DJANGO_SECRET_KEY=your-long-secret
DJANGO_DEBUG=0
DJANGO_ALLOWED_HOSTS=holisticcaregiverservices.com,www.holisticcaregiverservices.com

# Email (set to real SMTP)
EMAIL_BACKEND=django.core.mail.backends.smtp.EmailBackend
EMAIL_HOST=smtp.gmail.com
EMAIL_PORT=587
EMAIL_USE_TLS=1
EMAIL_HOST_USER=you@gmail.com
EMAIL_HOST_PASSWORD=app-password
DEFAULT_FROM_EMAIL=no-reply@holisticcaregiverservices.com
ADMIN_NOTIFY_EMAIL=info@holisticcaregiverservices.com

# Database (example MySQL)
DB_ENGINE=django.db.backends.mysql
DB_NAME=your_db
DB_USER=your_user
DB_PASSWORD=your_pass
DB_HOST=localhost
DB_PORT=3306

# WhatsApp Business Cloud API (optional)
WHATSAPP_CLOUD_TOKEN=EAA....
WHATSAPP_PHONE_NUMBER_ID=1234567890
WHATSAPP_VERIFY_TOKEN=your-verify-token
WHATSAPP_DEFAULT_ROUTE=+2349042510114
# Optional routing (by CareRequest.request_type or Enquiry.enquiry_type)
WHATSAPP_ROUTING_RULES=home_care=+234...,post_hospital=+234...,mental_transfer=+234...
```

## 2) Collect static files
```
python manage.py collectstatic
```

## 3) Migrations
```
python manage.py makemigrations
python manage.py migrate
```

## 4) VPS / DigitalOcean (recommended)
Install:
- Python 3.11+
- Nginx
- systemd

Run gunicorn:
```
gunicorn config.wsgi:application --bind 127.0.0.1:8001
```

Nginx proxy → 8001, and point static to `staticfiles/`.

## 5) cPanel (Setup Python App)
- Create a Python app
- Set app root to the project folder
- Set WSGI to `config/wsgi.py`
- Add environment variables in cPanel
- Run migrations from cPanel terminal (if available) or via SSH.

## 6) WhatsApp Webhook
Set webhook URL in Meta Developer console:
`https://YOURDOMAIN/whatsapp/webhook/`
Verification token must match `WHATSAPP_VERIFY_TOKEN`.

